///////////////////////////////
#include <acknex.h>
#include <default.c>
#include <mtlFX.c>
///////////////////////////////

//Tentacle Test
var segments = 50;
var roots = 20;
var speed = 3;

action segment()
{
	set(my,PASSABLE);
	my.material = mtl_specBump;
	
	my.skill1 = handle(you);
	my.skill2 = you.skill2 + 1;
	
	my.scale_x = you.scale_x * .95;
	my.scale_y = my.scale_x;
	my.scale_z = my.scale_x;
	
	//initialize movement variables
	var my_angles;
	var my_speed = speed;
	
	//create next segment
	if(my.skill2 < segments)
	{
		ent_create("tentacle.mdl",my.x,segment);
	}
	
	//start loop
	while(1)
	{
		you = ptr_for_handle(my.skill1);
		
		//make rotation changes
		my_angles += my_speed * time_step;
		my.pan = you.pan + 5 * sin(my_angles);
		my.tilt = you.tilt + 5 * sin(my_angles);
		my.roll = you.roll + 5 * sin(my_angles);
		vec_for_vertex(my.x,you,15);
		
		wait(1);
	}
}

var pan_mod = 0;
var tilt_mod = 0;
var roll_mod = 0;

action root()
{
	random_seed(0);
	my.pan = random(360) + pan_mod;
	random_seed(0);
	my.tilt = random(90) + tilt_mod;
	random_seed(0);
	my.roll = random(360) + roll_mod;
	
	random_seed(0);
	pan_mod += random(45) + 15;
	random_seed(0);
	tilt_mod += random(45) + 15;
	random_seed(0);
	roll_mod += random(45) + 15;
	
	set(my,PASSABLE);
	my.material = mtl_specBump;
	ent_create("tentacle.mdl",my.x,segment);
	
	
	if(roots > 0)
	{
		roots -= 1;
		ent_create("tentacle.mdl",my.x,root);
	}
}

function main()
{
	sky_color.red = 0;
	sky_color.green = 57;
	sky_color.blue = 77; // bright blue sky 

	d3d_antialias = 9;

	level_load("Tentacles.WMB");
	wait(2);
}